using System;
using System.Text;
using System.Collections.Specialized;
using Borland.Eco.Services;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Persistence;
using Borland.Eco.Framework;
using Borland.Eco.UmlRt;
using Borland.Eco.Handles;

namespace CustomServices
{
	public class PersistenceServiceBase: IPersistenceService
	{
		private IPersistenceService nextPersistenceService;
		public IPersistenceService NextPersistenceService { get { return nextPersistenceService;} set {nextPersistenceService = value;}}

		public virtual void UpdateDatabaseWithList(IObjectList list) { nextPersistenceService.UpdateDatabaseWithList(list); }
		public void UpdateDatabase(IObjectInstance obj) { nextPersistenceService.UpdateDatabase(obj); }

		public virtual bool SupportsSync { get { return nextPersistenceService.SupportsSync; }}
		public virtual void Refresh(bool fetchValues) { nextPersistenceService.Refresh(fetchValues); }
		public virtual void RetrieveChanges() { nextPersistenceService.RetrieveChanges(); }
		public virtual IChange[] GetChanges() { return nextPersistenceService.GetChanges(); }
		public virtual void ApplyAllChanges() { nextPersistenceService.ApplyAllChanges(); }
		public virtual IObjectList GetAllWithCondition(AbstractCondition condition) { return nextPersistenceService.GetAllWithCondition(condition); }
		public virtual IObjectList GetAllWithCondition(AbstractCondition condition, int maxAnswers, int offset) { return nextPersistenceService.GetAllWithCondition(condition, maxAnswers, offset); }
		public virtual void EnsureEnclosure(IObjectList list){ nextPersistenceService.EnsureEnclosure(list); }
		public virtual void Unload(IObjectList objects) { nextPersistenceService.Unload(objects); }
		public virtual void Unload(IObject obj) { nextPersistenceService.Unload(obj); }
		public virtual void EnsureRange(IObjectList objects, int fromIndex, int toIndex) { nextPersistenceService.EnsureRange(objects, fromIndex, toIndex); }
		public virtual void EnsureRelatedObjects(IObjectList objects, string memberName){ nextPersistenceService.EnsureRelatedObjects(objects, memberName); }
		public virtual bool IsPersistent { get { return nextPersistenceService.IsPersistent; }}

	}

	public class ValidatingPersistenceService: PersistenceServiceBase
	{
		public bool CheckConstraints(IObject obj, StringCollection messages)
		{
			bool res = true;
			IClass modeledClass = (IClass)obj.UmlType;
			IOclService oclService = obj.ServiceProvider.GetEcoService(typeof(IOclService)) as IOclService;
			for (int i = 0; i < modeledClass.Constraints.Count; i++)
			{
				IConstraint constraint = modeledClass.Constraints[i];
				string constraintExpression = constraint.Body.Body;

				IElement constraintResult = oclService.EvaluateAndSubscribe(obj, constraintExpression, null, null);
				if ((constraintResult != null) && (constraintResult.AsObject is System.Boolean))
				{
					if (!(bool)constraintResult.AsObject)
					{
						res = false;
						messages.Add(constraint.Name);
					}
				}
			}
			return res;
		}
		public virtual bool ValidateObject(IObject obj, StringCollection messages)
		{
			return CheckConstraints(obj, messages);
		}
		public override void UpdateDatabaseWithList(IObjectList list)
		{
			EnsureEnclosure(list);
			StringCollection messages = new StringCollection();
			foreach (IObject obj in list)
			{
				CheckConstraints(obj, messages);
			}
			if (messages.Count != 0)
			{
				StringBuilder sb = new StringBuilder();
				foreach (string s in messages)
					sb.Append(s+"\n\r");
				throw new Exception(sb.ToString());
            }
			base.UpdateDatabaseWithList(list);
		}
		
		public void InstallService(EcoServiceProvider serviceProvider)
		{
			NextPersistenceService = serviceProvider.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
			serviceProvider.RegisterEcoService(typeof(IPersistenceService), this);
		}

	}
}
